function meshplot( nodes, elems, fName )
  sz = size( elems );
  nElems = sz(1);
  x = zeros( 4, 1 );
  y = zeros( 4, 1 );
  FID = fopen( fName, 'wb' );
  fprintf( FID, '/m {moveto} def\n' );
  fprintf( FID, '/l {lineto} def\n' );
  fprintf( FID, '0.001 setlinewidth\n' );
  fprintf( FID, '144 216 translate\n' );
  fprintf( FID, '144 144 scale\n' );
  for idx = 1:nElems
    n1 = elems( idx, 1 );
    n2 = elems( idx, 2 );
    n3 = elems( idx, 3 );
    x(1) = nodes( n1, 1 );
    y(1) = nodes( n1, 2 );
    x(2) = nodes( n2, 1 );
    y(2) = nodes( n2, 2 );
    x(3) = nodes( n3, 1 );
    y(3) = nodes( n3, 2 );
    x(4) = nodes( n1, 1 );
    y(4) = nodes( n1, 2 );
    fprintf( FID, '%f %f m\n', x(1), y(1) );
    fprintf( FID, '%f %f l\n', x(2), y(2) );
    fprintf( FID, '%f %f l\n', x(3), y(3) );
    fprintf( FID, 'closepath stroke\n' );
  end
  fclose( FID );
