
function [elems, nodes, fvIdx, pvIdx, pvals] ...
            = ellCoaxMesh( A, B, a, b, alpha, m, n )
  nElems = 2 * m * n;
  nNodes = (n+1) * m;
  nPvals = 2 * m;

  elems = zeros( nElems, 3 );
  nodes = zeros( nNodes, 2 );
  pvals = zeros( nPvals, 1 );

  pvals(1:m) = ones(m,1);

  fvIdx = [(m+1):(n*m)];
  pvIdx = [1:m,(n*m + 1):nNodes];

  aa = a * a;
  bb = b * b;
  AA = A * A;
  BB = B * B;
  angStep = 2*pi / m;
  ang = 0.0;
  tStep = 1.0 / n;
  for k = 1:m
    c = cos( ang - alpha );
    s = sin( ang - alpha );
    C = cos( ang );
    S = sin( ang );
    r1 = a * b / sqrt( aa - ( aa - bb ) * c * c );
    r2 = A * B / sqrt( AA - ( AA - BB ) * C * C );
    xStart = r1 * C;
    yStart = r1 * S;
    xStop = r2 * C;
    yStop = r2 * S;
    t = 0.0;
    for l = 1:n+1
      x = (1-t) * xStart + t * xStop;
      y = (1-t) * yStart + t * yStop;
      j = (l-1) * m + k;
      nodes(j,1) = x;
      nodes(j,2) = y;
      t = t + tStep;
    end
    ang = ang + angStep;
  end

  j = 1;
  for l = 1:n
    for k = 1:(m-1)
      n1 = (l-1) * m + k;
      n2 = n1 + m;
      n3 = n2 + 1;
      n4 = n1 + 1;
      elems(j,1) = n1;
      elems(j,2) = n3;
      elems(j,3) = n4;
      j = j + 1;
      elems(j,1) = n1;
      elems(j,2) = n2;
      elems(j,3) = n3;
      j = j + 1;
    end
    n1 = l * m;
    n2 = n1 + m;
    n3 = n1 + 1;
    n4 = n3 - m ;
    elems(j,1) = n1;
    elems(j,2) = n3;
    elems(j,3) = n4;
    j = j + 1;
    elems(j,1) = n1;
    elems(j,2) = n2;
    elems(j,3) = n3;
    j = j + 1;
  end
