
function [S, T] = findST( elems, nodes )
  sz = size( elems );
  nElems = sz(1);
  sz = size( nodes );
  nNodes = sz(1);

  S = zeros( nNodes, nNodes );
  T = zeros( nNodes, nNodes );

  for idxE = 1:nElems
    n1 = elems( idxE, 1 );
    n2 = elems( idxE, 2 );
    n3 = elems( idxE, 3 );
    x1 = nodes(n1, 1 );
    y1 = nodes(n1, 2 );
    x2 = nodes(n2, 1 );
    y2 = nodes(n2, 2 );
    x3 = nodes(n3, 1 );
    y3 = nodes(n3, 2 );

    den = 2 * ( (x2*y3 - x3*y2) + (x3*y1 - x1*y3) + (x1*y2 - x2*y1) );

    S11 = ( (y2-y3)*(y2-y3) + (x3-x2)*(x3-x2) )/den;
    S12 = ( (y2-y3)*(y3-y1) + (x3-x2)*(x1-x3) )/den;
    S13 = ( (y2-y3)*(y1-y2) + (x3-x2)*(x2-x1) )/den;
    S21 = S12;
    S22 = ( (y3-y1)*(y3-y1) + (x1-x3)*(x1-x3) )/den;
    S23 = ( (y3-y1)*(y1-y2) + (x1-x3)*(x2-x1) )/den;
    S31 = S13;
    S32 = S23;
    S33 = ( (y1-y2)*(y1-y2) + (x2-x1)*(x2-x1) )/den;

    S(n1,n1) = S(n1,n1) + S11;
    S(n1,n2) = S(n1,n2) + S12;
    S(n1,n3) = S(n1,n3) + S13;
    S(n2,n1) = S(n2,n1) + S21;
    S(n2,n2) = S(n2,n2) + S22;
    S(n2,n3) = S(n2,n3) + S23;
    S(n3,n1) = S(n3,n1) + S31;
    S(n3,n2) = S(n3,n2) + S32;
    S(n3,n3) = S(n3,n3) + S33;

    tdiag = den / 24.0;
    toffdiag = den / 48.0;
    T(n1,n1) = T(n1,n1) + tdiag;
    T(n1,n2) = T(n1,n2) + toffdiag;
    T(n1,n3) = T(n1,n3) + toffdiag;
    T(n2,n1) = T(n2,n1) + toffdiag;
    T(n2,n2) = T(n2,n2) + tdiag;
    T(n2,n3) = T(n2,n3) + toffdiag;
    T(n3,n1) = T(n3,n1) + toffdiag;
    T(n3,n2) = T(n3,n2) + toffdiag;
    T(n3,n3) = T(n3,n3) + tdiag;
  end
