function [elems, nodes, fvIdx, pvIdx, pvals] ...
            = rectMesh( a, b, m, n )
  nElems = 2 * m * n;
  nNodes = (n+1) * (m+1);
  nPvals = 2 * (m+n);

  elems = zeros( nElems, 3 );
  nodes = zeros( nNodes, 2 );
  pvals = zeros( nPvals, 1 );

  pvIdx = [1:(m+1)];
  i1 = m+2;
  for l = 2:n
    i2 = i1 + m;
    pvIdx = [pvIdx, i1, i2];
    i1 = i2 + 1;
  end
  i2 = i1 + m;
  pvIdx = [pvIdx, i1:i2];
  
  fvIdx = [];
  istart = m+3;
  for l = 2:n
    istop = istart + m - 2;
    fvIdx = [fvIdx, istart:istop];
    istart = istop + 3;
  end

  x = linspace( 0, a, m+1 );
  y = linspace( 0, b, n+1 );
  for k = 1:m+1
    for l = 1:n+1
      j = (l-1) * (m+1) + k;
      nodes(j,1) = x(k);
      nodes(j,2) = y(l);
    end
  end

  j = 1;
  for l = 1:n
    for k = 1:m
      n1 = (l-1) * (m+1) + k;
      n2 = l * (m+1) + k;
      elems(j,1) = n1;
      elems(j,2) = n1 + 1;
      elems(j,3) = n2 + 1;
      j = j + 1;
      elems(j,1) = n1;
      elems(j,2) = n2 + 1;
      elems(j,3) = n2;
      j = j + 1;
    end
  end
