function msRK2(m, k, x_0, v_0, tf, nsteps)
    msParams = [m; k];
    tstep = tf / nsteps;
    t = linspace(0, tf, nsteps + 1);
    omega_0 = sqrt(k/m);
    phi = omega_0 * t;
    cp = cos(phi);
    sp = sin(phi);
    xDisp = cp;
    xVel = (1.0/omega_0) * sp;
    xExact = x_0 * xDisp + v_0 * xVel;

    xRK = zeros(size(t));
    u = [x_0; v_0];
    xRK(1) = u(1);
    for k=1:nsteps
        uNext = stepRK2(tstep, t(k), u, 'fnMS', msParams);
        u = uNext;
        xRK(k+1) = u(1);
    end

    figure(1);
    plot(t, xRK, '-g;Euler Forward;', t, xExact, '-k;Exact;');
    grid on;
    figure(2);
    plot(t, xExact - xRK, '-r;Error;');
    grid on;
