function per = findSlowOscPeriod(a, q)
    M = monodromyM(a, q, 1000)
    lambda = eig(M)
    mv = max(abs(lambda));
    tol = 1e-6;
    if (mv >= (1 + tol))
        % Why did we use (1 + tol)?
        error('UNSTABLE');
    end
    xiPerCycle = pi;
    angPerCycle = abs(angle(lambda(1)))
    per = xiPerCycle * 2 * pi / angPerCycle;
