function M = monodromyM(a, q, nSteps)
    mpar = [a; q];
    xiStep = pi / nSteps;

    u = [1; 0];
    v = [0; 1];
    xi = 0;
    for k = 1:nSteps
        uNext = stepRK4(xiStep, xi, u, 'slopeMathieu', mpar);
        u = uNext;
        vNext = stepRK4(xiStep, xi, v, 'slopeMathieu', mpar);
        v = vNext;
        xi = xi + xiStep;
    end
    M = [u, v];
