function [zArr, zDArr, xiArr] = solveMathieu(a, q, z_0, zD_0, xiFinal, nSteps)
    mpar = [a; q];
    xiStep = xiFinal / nSteps;
    xiArr = linspace(0, xiFinal, nSteps + 1);
    zArr = zeros(size(xiArr));
    zDArr = zeros(size(xiArr));

    u = [z_0; zD_0];
    zArr(1) = u(1);
    zDArr(1) = u(2);
    for k = 1:nSteps
        uNext = stepRK4(xiStep, xiArr(k), u, 'slopeMathieu', mpar);
        u = uNext;
        zArr(k+1) = u(1);
        zDArr(k+1) = u(2);
    end
